/*
Michael Otte, MIT, 2013


Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// gcc retina_viewer.c -o retina_viewer -lglut -lGL -lGLU -lGLEW

#include "retina_viewer.h"       //include header file with defined functions
#include "otteDVSreader.c"  //include retina driver

char title[] = "Data"; //title the window/file you are creating

//set size of the window
uint WIDTH = 300;
uint HEIGHT = 300;

//set number of pixels to draw
float xPixels = 128.0;
float yPixels = 128.0;

// function to display data
void drawData(int** data) {
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT);

	glLoadIdentity();
        glTranslatef(-1.0, -1.0, 0.0f); // set (0,0) in the corner
	
	glPushMatrix();
	glScalef(2.0/(xPixels), 2.0/(yPixels), 1.0f);


        glBegin(GL_QUADS);
        int i, j;
        for(i = 0; i < (int)yPixels; i++)
        {
          for(j = 0; j < (int)xPixels; j++)
          {

            if(data[i][j] == -1)   
              glColor3f(0.5, 0.5, 0.5);
            else if(data[i][j] == 1)
              glColor3f(1.0, 1.0, 1.0);
            else // data[i][j] == 0
              glColor3f(0.0, 0.0, 0.0);
           
	    glVertex2f((float)j+1, (float)i);
	    glVertex2f((float)j+1, (float)i+1);
	    glVertex2f((float)j, (float)i+1);
	    glVertex2f((float)j, (float)i);
          } 
        }  
	glEnd();

	glPopMatrix();
	glutPostRedisplay();
	glutSwapBuffers();
}

//resets data to all -1
void wipeData(int** data)
{
        int i, j;
        for(i = 0; i < (int)yPixels; i++)
        {
          for(j = 0; j < (int)xPixels; j++)
          {
            data[i][j] = -1;
          } 
        }  
}

//reshape function
void reshape(GLsizei width, GLsizei height) {
	if (height == 0)
		height = 1;  // prevent divide by 0
	GLfloat aspect = (GLfloat)width / (GLfloat)height;
	glViewport(0, 0, width, height);
	glMatrixMode(GL_PROJECTION);  // To operate on the Projection matrix
	glLoadIdentity();             // Reset the projection matrix
	if (width >= height)
	{
		gluOrtho2D(-1.0 * aspect, 1.0 * aspect, -1.0, 1.0);
	}
	else
	{
		gluOrtho2D(-1.0, 1.0, -1.0 / aspect, 1.0 / aspect);
	}
}

//main function
int main(int argc,char** argv) {
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_SINGLE);
	glutInitWindowSize(WIDTH,HEIGHT);
	glutInitWindowPosition(50, 50);
	glutCreateWindow(title);

	glutReshapeFunc(reshape);

	glClearColor(0.0f, 0.8f, 1.0f, 1.0f);
	glClearDepth(1.0f);

	glLineWidth(2.0f);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glMatrixMode(GL_MODELVIEW);
	glutSwapBuffers();
	glutMainLoopEvent();

	// make structure to hold data
        int** data = (int**)calloc(yPixels, sizeof(int*));
        int i, j;
        for(i = 0; i < yPixels; i++)
        {
          data[i] = (int*)calloc(xPixels, sizeof(int));
        }
        wipeData(data);

 	// open device file
  	int file_desc = open("/dev/retina0", O_RDWR);
  	if (file_desc < 0) 
        {
    		printf("Can't open device file\n");
    		exit(-1);
  	}

        int k = 1;
	for(i = 10000; i > 0; i--) 
        {
          updateData(file_desc, data);
	  drawData(data);
          wipeData(data);
         // usleep(5000);
	}

	// delete data
        for(i = 0; i < (int)yPixels; i++)
        {
          free(data[i]);
        } 
        free(data);

	close(file_desc);
	return 0;
}
