/*
 * Modified (including java port) by Michael Otte, MIT, 2013
 * 
 * USB retina driver
 * Martin Ebner, IGI / TU Graz (ebner at igi.tugraz.at)
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation, version 2.
 *
 * This driver is based on the 2.6.3 version of drivers/usb/usb-skeleton.c
 * (Copyright (C) 2001-2004 Greg Kroah-Hartman (greg@kroah.com))
 *
 */

// Need to add the following line to /etc/udev/rules.d/62-fx2.rules
// KERNEL=="retina[0-9]", NAME="retina0", SYMLINK+="retina0", MODE="0666"

import java.io.*;

public class otteDVSReader
{
	// constantes used to help extract and parse stream data
	short xmask = 0x00fe;
	byte xshift = 1;
	short ymask = 0x7f00;
	byte yshift = 8;
	short typemask = 1;
	int sizeX = 128;
	int sizeY = 128;
	int sxm = sizeX - 1;  
	int READ_BUFFER_SIZE = 10000;

	byte[] buffer = new byte[READ_BUFFER_SIZE]; // the buffer used to read the stream
	FileInputStream in = null; // input files stream

	// non constants
	short TICK_US = 1;
	int wrapAdd = 0;

	public void openDVS()
	{
		try
        	{
			in = new FileInputStream("/dev/retina0");   
        	}
        	catch(Exception e)
        	{
         	   System.out.println(e);
        	}
	}

	public void closeDVS()
	{
		try
        	{
			in.close();
		}
        	catch(Exception e)
        	{
        	}
	}


	public void readDVS()
	{
		int bytesSent = 0;
		try
        	{
			bytesSent = in.read(buffer);
		}
        	catch(Exception e)
        	{
            		System.out.println(e);
        	}

		if( bytesSent % 4 != 0 )
		{
			bytesSent = (bytesSent / 4) * 4;
		}

		// parse data
		int i;
		for(i = 0; i < bytesSent; i+=4)
		{
			if ((buffer[i + 3] & 0x80) == 0x80)
			{
 				wrapAdd += 0x4000L;
 			}
			else if ((buffer[i + 3] & 0x40) == 0x40) 
			{
 				// this firmware version uses reset events to reset timestamps
			}
			else
			{
				int address = (int) ((buffer[i] & 0xFF) | ((buffer[i + 1] & 0xFF) << 8));
				int shortts = (buffer[i + 2] & 0xff | ((buffer[i + 3] & 0xff) << 8));
				int timestamp = (int) wrapAdd + (TICK_US * (shortts));
				byte polarity = (byte)(1 - address & 1); // 0 = polarity on, 1 polarity off
				short x = (short) (sxm - ((short) ((address & xmask) >>> xshift)));
				short y = (short) ((address & ymask) >>> yshift);
				//System.out.println("T:" + timestamp + ", p:" + polarity + ", x:" + x + ", y:" + y); 
			}
		}
		System.out.println("parsed: " + bytesSent/4); 
	}

	public static void main(String argv[]) 
	{
		otteDVSReader A = new otteDVSReader();
		A.openDVS();
		for(int i = 0; i < 1000; i++)
		{
			A.readDVS();
		}
		A.closeDVS();
	}
}
